 ; Ŀ
 ;   Ratt: make an ss of text into attdefs, don't offer any options.       
 ;   Copyright 1992, 2001, 2003 by Rocket Software Ltd.                    
 ;   AutoCAD: a group of commands which enable a computer to convert       
 ;   a series of hand movements into a pattern of light waves.             
 ; 

 ; Ŀ
 ;   Subroutine Fdash - split a string at any character in a list,         
 ;   capitalise each resulting substring, reassemble the string.           
 ;   Lifted from the routine Fcase - add initial caps to a text string.    
 ;                                                                         
 ;   Also watches for certain special cases.                               
 ;   Arguments: Astr: the string to process.                               
 ;              Chra: the list of separator characters.                    
 ;   Recursive.                                                            
 ; 
 (DEFUN FDASH (chra astr / sub prlist nustra nump)
  (if (and astr 
           (car chra)
           (> (length (setq prlist (splat (car chra) astr))) 0))
      (progn
           (setq nustra "")
           (while (setq sub (car prlist))
                  (setq prlist (cdr prlist))
                  (setq sub (strcase sub t))
                  (cond ((= (substr sub 1 1) "(")               ; balance: )
                         (setq sub (strcat "(" (car (hug (substr sub 2)))))) ;)
                        ((or (and (> (setq nump (sonar "." sub t)) 0)
                                  (/= (substr sub (strlen sub)) "."))
                             (> nump 1))
                         (setq sub (strcase sub)))
                        ((member sub '("vsat" "mds" "vavcu"))
                         (setq sub (strcase sub)))
                        (T (setq sub (car (hug sub)))))
                  (setq sub (fdash (cdr chra) sub))             ; recurse
                  (setq nustra (strcat nustra (car chra) sub)))
           (if (= (substr nustra 1 1) (car chra))
               (setq nustra (substr nustra 2))))
      (setq nustra astr))
 nustra)
 ; Ŀ
 ;   Fdash.                                                                
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / nustr)
  (setq nustr (strcat (strcase (substr exstr 1 1))
                      (strcase (substr exstr 2) t)))
 (list nustr (if (= exstr nustr) () t)))
 ; Ŀ
 ;   Hug - end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string at a given character, make    
 ;   into a list of substrings.                                            
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (and (/= linn "")
                     (= (substr linn (setq len (strlen linn))) " "))
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= name1 "")
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Ratt - make a text entity into an ivcp attdef.             
 ;   Arguments: Bent, an entity name.                                      
 ;              Fh, the fixed height flag.                                 
 ;   Calls everything, Returns nothing.                                    
 ; 
 (DEFUN RATT (bent fh / bb txtstr tag2 prompt3 def1 aa bbf nn asoc)
  (setq bb (entget bent))
 ; Ŀ
 ;   Tag value - this can't be an empty string or contain a space.         
 ;   It will be uppercase...                                               
 ; 
  (setq txtstr (cdr (assoc 1 bb)))
  (setq tag2 (strcase (car (splat " " txtstr))))
 ; Ŀ
 ;   Prompt.                                                               
 ; 
  (setq prompt3 (fdash (list " " "-" "/") txtstr))
 ; Ŀ
 ;   Default value ("").                                                   
 ; 
  (setq def1 "")
 ; Ŀ
 ;   The attdef command is one "" shorter if text style is fixed height.   
 ; 
  (if (= fh 0.0)
      (command ".attdef" "" "." "" "" (getvar "viewctr") "" "")
      (command ".attdef" "" "." "" "" (getvar "viewctr") ""))
 ; Ŀ
 ;   Remanufacture the new attdef to match the text & inputs.              
 ; 
  (setq aa (entget (entlast)))
  (setq bbf (list (assoc -1 aa) (assoc 0 aa)
                  (cons 1 def1) (cons 2 tag2) (cons 3 prompt3)))
  (setq nn 0)
  (while (nth nn bb)
         (setq asoc (car (nth nn bb)))
         (cond ((not (or (=  0 asoc)
                         (=  5 asoc)
                         (=  1 asoc)
                         (= -1 asoc)
                         (=  2 asoc)
                         (= 74 asoc)
                         (= 73 asoc)
                         (=  100 asoc)))
              (setq bbf (cons (nth nn bb) bbf)))
             ((= 73 asoc)
              (setq bbf (cons (cons 74 (cdr (nth nn bb))) bbf))))
         (setq nn (1+ nn)))
  (setq bbf (reverse bbf))
 ; Ŀ
 ;   Delete the original text entity, rehash the new attdef.               
 ; 
  (entdel bent)
  (entmod bbf)
 (princ))
 ; Ŀ
 ;   Ratt end.                                                             
 ; 

 ; Ŀ
 ;   Ratt.                                                                 
 ; 
 (DEFUN C:RATT (/ tt fh num ss enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq tt (getvar "textstyle"))                         ; get style
  (setq fh (cdr (assoc 40 (tblsearch "style" tt))))      ; fixed height?
  (setvar "aflags" 0)
  (prompt "Select text to convert to attdefs: ")
  (setq num 0)
  (if (setq ss (ssget '((0 . "text"))))
      (while (setq enam (ssname ss num))
             (setq num (1+ num))
             (ratt enam fh)))
  (command "undo" "end")
 (princ))